<?php
include 'services/session.php';
include 'includes/dbconn.php';

// Retrieve invoice_id from the URL
$invoice_id = isset($_GET['invoice_id']) ? $_GET['invoice_id'] : null;

if (!$invoice_id) {
    echo "No invoice ID provided";
    exit; // Exit if no invoice ID is provided
}

// Fetch invoice details from the database
$invoiceQuery = "SELECT invoices.*, clients.client_name, clients.address, clients.phone_number, clients.company FROM invoices JOIN clients ON invoices.client_id = clients.client_id WHERE invoices.invoice_id = ?";
$stmt = $conn->prepare($invoiceQuery);
$stmt->bind_param('i', $invoice_id);
$stmt->execute();
$invoiceResult = $stmt->get_result();

if ($invoiceResult->num_rows === 0) {
    echo "No invoice found with ID: " . htmlspecialchars($invoice_id);
    exit; // Exit if no invoice is found
}

$invoice = $invoiceResult->fetch_assoc();

// Fetch line items for the invoice
$lineItemsQuery = "SELECT * FROM invoice_line_items WHERE invoice_id = ?";
$lineItemsStmt = $conn->prepare($lineItemsQuery);
$lineItemsStmt->bind_param('i', $invoice_id);
$lineItemsStmt->execute();
$lineItemsResult = $lineItemsStmt->get_result();

$lineItems = [];
while ($lineItem = $lineItemsResult->fetch_assoc()) {
    $lineItems[] = $lineItem;
}

// Close the database connection
$conn->close();
?>


<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Invoice Details";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Invoice Details";
    include 'partials/menu.php'; ?>
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                  <!-- Start Content-->
                  <div class="container-fluid">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                 
                                    <div class="panel-body">
                                        <div class="clearfix">
                                            <div class="float-start">
                                                <h3>Faida Accounting System</h3>
                                                
                                            </div>
                                            <div class="float-end">
                                                <h4>Invoice ID: <br>
                                                    <strong><?php echo isset($invoice['invoice_id']) ? htmlspecialchars($invoice['invoice_id']) : 'Not Available'; ?></strong>
                                                </h4>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="row">
                                            <div class="col-md-12">
    
                                                <div class="float-start mt-3">
                                                    <address>
                                                        Client Name: <strong><?php echo htmlspecialchars($invoice['client_name']); ?></strong><br>
                                                        Company: <strong><?php echo htmlspecialchars($invoice['company']); ?><br></strong>
                                                        Client Address: <strong><?php echo htmlspecialchars($invoice['address']) . ', ' . htmlspecialchars($invoice['state']); ?><br></strong>
                                                        Client Phone: <strong><abbr title="Phone">P:</abbr> <?php echo htmlspecialchars($invoice['phone_number']); ?></strong>
                                                    </address>
                                                </div>
                                                <div class="float-end mt-3">
                                                    <p><strong>Due Date: </strong> <?php echo htmlspecialchars($invoice['due_date']); ?></p>
                                                    <p class="m-t-10"><strong>Order Status: </strong> <span class="label label-pink"><?php echo htmlspecialchars($invoice['payment_status']); ?></span></p>
                                                    <p class="m-t-10"><strong>Order ID: </strong> #<?php echo isset($invoice['invoice_id']) ? htmlspecialchars($invoice['invoice_id']) : 'Not Available'; ?></p>
                                                </div>
                                            </div><!-- end col -->
                                        </div>
                                        <!-- end row -->
    
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="table-responsive">
                                                    <table class="table mt-4">
                                                        <thead>
                                                        <tr><th>#</th>
                                                            <th>Item</th>
                                                            <th>Description</th>
                                                            <th>Quantity</th>
                                                            <th>Unit Cost</th>
                                                            <th>Total</th>
                                                        </tr></thead>
                                                        <tbody>
                                                            <?php foreach ($lineItems as $index => $item): ?>
                                                                <tr>
                                                                    <td><?php echo $index + 1; ?></td>
                                                                    <td><?php echo htmlspecialchars($item['invoice_id']); ?></td> <!-- Assuming 'description' is the item name -->
                                                                    <td><?php echo htmlspecialchars($item['description']); ?></td>
                                                                    <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                                                                    <td>$<?php echo htmlspecialchars($item['unit_price']); ?></td>
                                                                    <td>$<?php echo htmlspecialchars($item['total_amount']); ?></td>
                                                                </tr>
                                                            <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-6 col-6">
                                                <div class="clearfix mt-4">
                                                    <h5 class="small text-dark fw-normal">PAYMENT TERMS AND POLICIES</h5>
    
                                                    <small>
                                                        All accounts are to be paid within 7 days from receipt of
                                                        invoice. To be paid by cheque or credit card or direct payment
                                                        online. If account is not paid within 7 days the credits details
                                                        supplied as confirmation of work undertaken will be charged the
                                                        agreed quoted fee noted above.
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="col-xl-3 col-6 offset-xl-3">
                                                <p class="text-end"><b>Sub-total:</b> <?php echo htmlspecialchars($item['total_amount']); ?></p>
                                                <p class="text-end">Discount: <?php echo htmlspecialchars($item['discount']); ?></p>
                                                <p class="text-end">VAT: <?php echo htmlspecialchars($item['tax']); ?></p>
                                                <hr>
                                                <h3 class="text-end">USD <?php echo htmlspecialchars($item['total_amount']); ?></h3>
                                            </div>
                                        </div>
                                        <hr>
                                        <div class="d-print-none">
                                            <div class="float-end">
                                                <a href="javascript:window.print()" class="btn btn-dark waves-effect waves-light"><i class="fa fa-print"></i></a>
                                            </div>
                                            <div class="d-print-none mt-4">
                                                <input type="hidden" id="invoiceId" value="<?php echo $invoice_id; ?>">
                                                <button class="btn btn-success waves-effect waves-light" onclick="markPayment()">Mark Payment</button>
                                            </div>

                                            <div class="clearfix"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                          
                        </div>

                    </div>
                    <!-- end row -->        
                    
                </div> <!-- container-fluid -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
        <script>
            function markPayment() {
                // Assuming $invoice_id is already set on your page
                var invoiceId = "<?php echo $invoice_id; ?>";
        
                // Redirect to process_payment.php with the invoice_id
                window.location.href = "process_payment.php?invoice_id=" + invoiceId;
            }
        </script>

    </body>
</html>